import sys

# Tworzenie obrazka (należy upewnić się, że jest on prostokątem!)
im = [list('..########################...........'),
      list('..#......................#...#####...'),
      list('..#..........########....#####...#...'),
      list('..#..........#......#............#...'),
      list('..#..........########.........####...'),
      list('..######......................#......'),
      list('.......#..#####.....###########......'),
      list('.......####...#######................')]

HEIGHT = len(im)
WIDTH = len(im[0])

def floodFill(image, x, y, newChar):
    oldChar = image[y][x]
    pixelsToCheck = [[x, y]]

    while len(pixelsToCheck) > 0:
      x, y = pixelsToCheck.pop()
      if oldChar == newChar or image[y][x] != oldChar:
          # PRZYPADEK BAZOWY
          continue

      image[y][x] = newChar # Zmiana znaku.

      # Odkomentuj, aby wyświetlić poszczególne kroki:
      #printImage(image)

      # Change the neighboring characters.
      if y + 1 < HEIGHT and image[y + 1][x] == oldChar:
          # PRZYPADEK REKURENCYJNY
          pixelsToCheck.append([x, y + 1])
      if y - 1 >= 0 and image[y - 1][x] == oldChar:
          # PRZYPADEK REKURENCYJNY
          pixelsToCheck.append([x, y - 1])
      if x + 1 < WIDTH and image[y][x + 1] == oldChar:
          # PRZYPADEK REKURENCYJNY
          pixelsToCheck.append([x + 1, y])
      if x - 1 >= 0 and image[y][x - 1] == oldChar:
          # PRZYPADEK REKURENCYJNY
          pixelsToCheck.append([x - 1, y])

def printImage(image):
    for y in range(HEIGHT):
        # Wyświetlanie każdego wiersza.
        for x in range(WIDTH):
            # Wyświetlanie każdej kolumny.
            sys.stdout.write(image[y][x])
        sys.stdout.write('\n')
    sys.stdout.write('\n')

printImage(im)
floodFill(im, 3, 3, 'o')
printImage(im)
